class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Whitehorse Star'
    oldest_article = 7
    max_articles_per_feed = 100
    
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                    


    remove_tags = [dict(name='div', attrs={'class':['story-comments','add-comment','leaderboard-top','toolbar-archive']}),
                   dict(name='div', attrs={'id':['footer','top','sub-menu']}),
                   dict(name='ul', attrs={'class':['']}),
                   dict(name='ul', attrs={'id':['']}),
                   dict(name='img'),]

    feeds          = [(u'News', u'http://feeds.feedburner.com/whitehorsestarcomnews'), 
                          (u'Events', u'http://feeds.feedburner.com/whitehorsestarcomevents'), 
                          (u'Blog', u'http://feeds.feedburner.com/whitehorsestarcomblog')]
                         


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup